@extends('Template::layouts.master')

@section('content')
    <form method="post" enctype="multipart/form-data">
        @csrf
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card custom--card">
                    <div class="card-body">
                        <div class="form-group">
                            <label class="form--label">@lang('Wallet')</label>
                            <select class="form--control select2" data-minimum-results-for-search="-1" name="wallet"
                                required>
                                <option value="">@lang('Select a wallet')</option>
                                <option value="deposit_wallet">@lang('Deposit Wallet') - {{ showAmount($user->deposit_wallet) }}
                                </option>
                                <option value="interest_wallet">@lang('Interest Wallet') - {{ showAmount($user->interest_wallet) }}
                                </option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form--label">@lang('Username')</label>
                            <input type="text" name="username" class="form--control findUs form-twoer" required>
                            <code class="error-message"></code>
                        </div>
                        <div class="form-group">
                            <label class="form--label">@lang('Amount') <small class="text--success">(@lang('Charge'):
                                    {{ getAmount(gs('f_charge')) }} + {{ getAmount(gs('p_charge')) }}%)</small></label>
                            <div class="input-group">
                                <input type="number" step="any" autocomplete="off" name="amount"
                                    class="form--control form-control">
                                <span class="input-group-text input-style">{{ gs('cur_text') }}</span>
                            </div>
                            <small><code class="calculation"></code></small>
                        </div>
                        @if (auth()->user()->ts)
                            <div class="form-group">
                                <label class="form--label">@lang('Google Authenticator Code')</label>
                                <input type="text" name="authenticator_code" class="form-control" required>
                            </div>
                        @endif
                        <div class="form-group mt-3">
                            <button type="submit" class="btn btn--base w-100 ">@lang('Transfer')</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection


@push('script')
    <script>
        $('input[name=amount]').on('input', function() {
            var amo = parseFloat($(this).val());
            var calculation = amo + (parseFloat({{ gs('f_charge') }}) + (amo * parseFloat({{ gs('p_charge') }})) /
                100);
            if (calculation) {
                $('.calculation').text(calculation + ' {{ gs('cur_text') }} will cut from your selected wallet');
            } else {
                $('.calculation').text('');
            }
        });

        $('.findUser').on('focusout', function(e) {
            var url = '{{ route('user.findUser') }}';
            var value = $(this).val();
            var token = '{{ csrf_token() }}';

            var data = {
                username: value,
                _token: token
            }
            $.post(url, data, function(response) {
                if (response.message) {
                    $('.error-message').text(response.message);
                } else {
                    $('.error-message').text('');
                }
            });
        });
    </script>
@endpush
